package de.renew.io.exportFormats;

import java.io.File;
import java.io.FileOutputStream;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.exportFormats.ExportFormatAbstract;
import de.renew.gui.CPNDrawing;
import de.renew.gui.pnml.PNMLFormat;
import de.renew.io.PNMLFileFilter;

/**
 * This class is an Exporter for PNML.
 */
public abstract class PNMLExportFormat extends ExportFormatAbstract {
    /**
     * Declares value of PtNetType.
     */
    public static final String ptNetType = "http://www.pnml.org/version-2009/grammar/ptnet";
    /**
     * Declares value of refNetType.
     */
    public static final String refNetType = "RefNet";
    private final String _type;
    private final boolean _toolInsc;

    /**
     * This decides on the formatting of the export.
     * @param name of the PNML
     * @param type of the PtNet
     * @param toolInsc boolean
     */
    public PNMLExportFormat(String name, String type, boolean toolInsc) {
        super("PNML-" + name, new PNMLFileFilter());
        _type = type;
        _toolInsc = toolInsc;
    }


    @Override
    public boolean canExportNto1() {
        return true;
    }


    @Override
    public File export(Drawing drawing, File path) throws Exception {
        if (drawing != null && path != null) {
            FileOutputStream stream = new FileOutputStream(path);
            PNMLFormat format = new PNMLFormat(_type, _toolInsc);
            format.write(stream, (CPNDrawing) drawing);
            return path;
        }

        return null;
    }


    @Override
    public File export(Drawing[] drawings, File path) throws Exception {
        if (drawings != null && path != null) {
            FileOutputStream stream = new FileOutputStream(path);
            PNMLFormat format = new PNMLFormat(_type, _toolInsc);
            CPNDrawing[] cpn = new CPNDrawing[drawings.length];
            for (int pos = 0; pos < cpn.length; pos++) {
                cpn[pos] = (CPNDrawing) drawings[pos];
            }
            format.write(stream, cpn);
            return path;
        }

        return null;
    }

    @Override
    public boolean canExportDrawing(Drawing drawing) {
        return drawing instanceof CPNDrawing;
    }
}