package de.renew.io.exportFormats;

import java.io.File;
import javax.naming.OperationNotSupportedException;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.exportFormats.ExportFormatMultiAbstract;
import de.renew.gui.CPNDrawing;

/**
 * Formats XML Files for Export.
 */
public class XMLExportFormat extends ExportFormatMultiAbstract {

    /**
     * Constructor for an XMLExportFormat
     */
    public XMLExportFormat() {
        super("XML", "XML FileFilter");
        init();
    }

    /**
      * Initiation for XMLImportFormat
      */
    protected void init() {
        addExportFormat(new PNMLPTExportFormat());
        addExportFormat(new PNMLPTwtiExportFormat());
        addExportFormat(new PNMLRefNetExportFormat());
    }

    @Override
    public File export(Drawing drawing, File path) throws Exception {
        // TODO should this method exist in implementations of ExportFormatMultiAbstract?
        throw new OperationNotSupportedException();
    }


    @Override
    public File export(Drawing[] drawings, File path) throws Exception {
        // TODO should this method exist in implementations of ExportFormatMultiAbstract?
        throw new OperationNotSupportedException();
    }

    @Override
    public boolean canExportDrawing(Drawing drawing) {
        // TODO should this method exist in implementations of ExportFormatMultiAbstract?
        return drawing instanceof CPNDrawing;
    }
}