package de.renew.gui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;

import CH.ifa.draw.framework.Drawing;
import de.renew.shadow.ShadowCompilerFactory;
import de.renew.shadow.ShadowNetSystem;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.mockStatic;

class ShadowNetSystemRendererTest {

    /**
     * Test {@link ShadowNetSystemRenderer#render(URL)}.
     * If an empty ShadowNetSystem is read or the file could not be read, return an empty list.
     */
    @Test
    void render() throws MalformedURLException {
        // a valid url pointing to a non-existant file
        URL dummyUrl = new URL("file://unknown.file");

        // test if net is empty
        try (MockedStatic<ShadowNetSystemRenderer> aStatic =
            mockStatic(ShadowNetSystemRenderer.class)) {
            // mock static class during this try-block

            ShadowCompilerFactory compilerFactory = mock(ShadowCompilerFactory.class);
            ShadowNetSystem emptySystem = new ShadowNetSystem(compilerFactory);

            aStatic.when(() -> ShadowNetSystemRenderer.readShadowNetSystem(dummyUrl))
                .thenReturn(emptySystem);
            List<Drawing> drawings =
                assertDoesNotThrow(() -> ShadowNetSystemRenderer.render(dummyUrl));
            assertNotNull(drawings);
            assertEquals(0, drawings.size());
        }

        // test if file is invalid
        List<Drawing> drawings = assertDoesNotThrow(() -> ShadowNetSystemRenderer.render(dummyUrl));
        assertNotNull(drawings);
        assertEquals(0, drawings.size());
    }
}