package de.renew.gui;

import java.util.Collection;
import javax.swing.*;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.mock;

class SimulationMenuCreatorTest {

    private SimulationMenuCreator creator;

    @BeforeEach
    void beforeEach() {
        creator = new SimulationMenuCreator();
    }

    /**
     * Test {@link SimulationMenuCreator#createMenus(BreakpointManager)}.
     * <p>
     *     Test that it does not throw.
     *     Test that a non-empty collection is returned.
     * </p>
     * TODO: for more serious/better tests, the method to test requires Refactoring
     */
    @Test
    void createMenus() {
        BreakpointManager manager = mock(BreakpointManager.class);

        Collection<JMenuItem> menus = assertDoesNotThrow(() -> creator.createMenus(manager));

        assertNotNull(menus);
        assertNotEquals(0, menus.size());
    }

    /**
     * Test {@link SimulationMenuCreator#initSimulation()}.
     * FIXME: currently no valid tests can be made, method requires refactoring
     */
    @Test
    void initSimulation() {}

    /**
     * Test {@link SimulationMenuCreator#promptLoadSimulationState()}.
     * TODO: write tests
     */
    @Test
    void promptLoadSimulationState() {}

    /**
     * Test {@link SimulationMenuCreator#promptSaveSimulationState()}.
     * TODO: write tests
     */
    @Test
    void promptSaveSimulationState() {}
}