package de.renew.layoutwindow;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;

import CH.ifa.draw.standard.AlignCommand;
import CH.ifa.draw.util.Command;


/**
 * An ActionListener that executes a specific AlignCommand based on the
 * current selection of a JComboBox (Swing).
 */
public class AlignCommandActionListener implements ActionListener {
    private final Command[] _commands;
    private final JComboBox<String> _combobox;

    /**
     * Constructor of the class AlignCommandActionListener.
     *
     * @param name the base name for each generated alignment command
     * @param op the operation code specifying the alignment type
     * @param combobox the JComboBox whose items determine the available commands
     */
    public AlignCommandActionListener(String name, int op, JComboBox<String> combobox) {
        this._combobox = combobox;
        int n = combobox.getItemCount();

        this._commands = new Command[n];
        for (int i = 0; i < n; i++) {
            Object item = combobox.getItemAt(i);
            this._commands[i] = new AlignCommand(name + " " + item, op, i);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        int selectedIndex = _combobox.getSelectedIndex();
        this._commands[selectedIndex].execute();
    }
}