package de.renew.layoutwindow;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import CH.ifa.draw.util.Command;


/**
 * An {@link ActionListener} that wraps a {@link Command} and executes it when an action is performed.
 * This class is typically used to bind a command to a UI component such as a button.
 */
public class CommandActionListener implements ActionListener {

    /** Command used to execute an action */
    protected Command _command;

    /**
     * Creates the listener with a specific command to execute.
     *
     * @param command the command to be executed when an action is performed
     */
    public CommandActionListener(Command command) {
        this._command = command;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this._command.execute();
    }
}