package de.renew.plugin;

/**
 * Exception thrown when there was no available service provider
 * for a requested service.
 */
public class ServiceLookupException extends Exception {

    /**
     * Constructs a new instance for the given service
     *
     * @param service   The service for which a provider was to be found
     */
    public ServiceLookupException(Class<?> service) {
        super(
            "While trying to load a service provider for the service " + service
                + ", the service lookup infrastructure (SLI) "
                + "was unable to find a matching implementation. "
                + "A provider might be made available at a later time, "
                + "but theres no guarantee that this is the case."
                + "Please make sure that a implementation for your service exists "
                + "and is provided by a loaded module.");
    }
}
