package de.renew.plugin.command;

import java.io.IOException;
import java.io.PrintStream;


/**
 * A {@link CLCommand} that may prompt for additional user input during execution.
 * <p>
 * Implementations must ensure proper functionality in environments where dynamic
 * user input is unsupported, relying on provided arguments only <i>({@link
 * #execute(String[], PrintStream)})</i>.
 */
public interface InteractiveCLCommand extends CLCommand {
    /**
     * Supplier for reading additional user input using the prompt a command is executed in.
     */
    @FunctionalInterface
    interface InputSupplier {
        /**
         * Get the result as String.
         * @return the read user input.
         * @throws IOException if an error error occurs while trying to read the user input.
         */
        String get() throws IOException;
    }

    /**
     * Trigger the functionality represented by this command. The prompt
     * implementation may ask for additional user input during execution.
     *
     * @param args      The command line that was typed by the user.
     * @param response  The <code>PrintStream</code> for user feedback.
     * @param additionalInputSupplier  a function that can be called to ask for additional user input
     */
    void execute(String[] args, PrintStream response, InputSupplier additionalInputSupplier);
}
