package de.renew.plugin.di;


/**
 * Is thrown when an a service can not resolve its dependencies
 * @author Konstantin Simon Maria Moellers
 * @version 2015-10-10
 */
public class MissingDependencyException extends Exception {
    /**
     * Returns missing dependency from given dependency
     * @param dependency The dependency to be checked
     */
    public MissingDependencyException(Class<?> dependency) {
        super(String.format("Dependency '%s' is missing", dependency.getSimpleName()));
    }
}