package de.renew.plugin.jpms;


/**
 * A reification strategy used by the module layer management on how to process
 * encountered unresolved qualified exports.
 *
 * @author Kjell Ehlers
 * @since Renew 4.2
 */
public interface ExportsStrategy {

    /**
     * Invoked  during the initialisation of the module layer  management.  All
     * qualified  exports of modules from the  {@link ComponentLayer#BOOT  boot
     * layer}  with  destination being a module in a different  layer,  can  be
     * considered unresolved.
     */
    void putUnresolvedExportsFromBoot();

    /**
     * Invoked during the creation of a new {@code ComponentLayer}. This method
     * is called for every module in the layer, without filtering the  module's
     * requirements for unresolved qualified exports, so this might be a no-op.
     *
     * @param src the module to test for unresolved exports.
     * @param control the controller obj of the module's layer.
     */
    void putUnresolvedExportsFrom(Module src, ModuleLayer.Controller control);

    /**
     * Invoked during the creation of a new {@code ComponentLayer}. This method
     * is  called for every module in the layer to try and  resolve  previously
     * encountered unresolved exports.
     *
     * @param target the module for which exports shall be resolved.
     */
    void tryResolveExportsTo(Module target);
}
