package de.renew.plugin.jpms;

/**
 * This exception is thrown by the Module manager if a module does not fulfill the conventions.
 */
public class ModuleConfigurationException extends RuntimeException {
    /**
     * The exception checks whether the conventions for a module are being fulfilled.
     * If conventions are not met an error message is being displayed.
     * @param message A String is handed over to the ModuleConfigurationException
     */
    public ModuleConfigurationException(String message) {
        super(message);
    }
}
