package de.renew.plugin.jpms.impl;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

import de.renew.plugin.jpms.AbstractLayerFactory;
import de.renew.plugin.jpms.ComponentLayer;


/**
 * A {@code ComponentLayerFactory} for {@code LibraryLayer}s.
 * <p>
 * Each new {@code LibraryLayer} gets assigned a new global identifier.
 *
 * @author Kjell Ehlers
 * @since Renew 4.2
 */
public class LibraryLayerFactory extends AbstractLayerFactory {
    private static final AtomicLong COUNT = new AtomicLong();

    @Override
    public ComponentLayer createComponentLayer(
        String name, ModuleLayer.Controller control, List<ComponentLayer> parents)
    {
        return new LibraryLayer(COUNT.getAndIncrement(), control, parents);
    }

    @Override
    protected boolean verify(ModuleLayer layer, Set<String> modulesToLoad) {
        return !layer.modules().isEmpty();
    }
}
