package de.renew.plugin.propertymanagement;

import java.util.Map;


/**
 * Interface for classes that can save and load configurable properties to and from a file.
 */
public interface IConfigurablePropertyPersister {

    /**
     * Saves the given configurable properties to a file, either in the user's home directory
     * or in the application's configuration directory.
     *
     * @param useHomeDir If {@code true}, the properties will be saved to a file in the user's home directory
     * (e.g., ~/.renew.properties). If {@code false}, the properties will be saved to a file
     * in the application's configuration directory (e.g., config/renew.properties).
     * @param propertyMap The map of properties to save.
     * @throws PropertySaveFailedException If there is an issue saving the properties.
     */
    void saveProperties(boolean useHomeDir, Map<String, ConfigurableProperty> propertyMap)
        throws PropertySaveFailedException;

    /**
     * Loads the current set of configurable properties from a file, either in the user's home directory
     * or in the application's configuration directory.
     *
     * @param useHomeDir If true, the properties will be loaded from a file in the user's home directory
     * (e.g., homeDir/.renew.properties). If false, the properties will be loaded from a file
     * in the application's configuration directory (e.g., config/renew.properties).
     * @param propertyMap The map of properties to load the values into.
     * @throws PropertyLoadFailedException If there is an issue loading the properties.
     */
    void loadProperties(boolean useHomeDir, Map<String, ConfigurableProperty> propertyMap)
        throws PropertyLoadFailedException;
}
