package de.renew.plugin.propertymanagement;

/**
 * The PropertyChangeType enum represents the type of change that has occurred in a configurable property.
 * It defines three possible types of property changes: PROPERTY_ADDED, PROPERTY_CHANGED, and PROPERTY_REMOVED.
 */
public enum PropertyChangeType {
    /**
     * Indicates that a new property has been added.
     */
    PROPERTY_ADDED,
    /**
     * Indicates that an existing property has been changed.
     */
    PROPERTY_CHANGED,
    /**
     * Indicates that an existing property has been removed.
     */
    PROPERTY_REMOVED
}
