/**
 * {@summary The Loader plugin provides a load-plugin concept for Renew.
 * The Loader allows to locate plugins that may be loaded, load the plugins that were found and control the plugins'
 * life cycles.
 * }
 * <p>
 * The module provides the packages {@link de.renew.plugin} which
 * includes the packages {@link de.renew.plugin.load}, {@link de.renew.plugin.command},
 * {@link de.renew.plugin.annotations}, {@link de.renew.plugin.di}, {@link de.renew.plugin.locate} and the package
 * {@link de.renew.plugin.propertymanagement}. Additionally, the module provides the package de.renew.logging.
 */

module de.renew.loader {
    // Provided Packages
    exports de.renew.plugin;
    exports de.renew.plugin.load;
    exports de.renew.plugin.command;
    exports de.renew.plugin.annotations;
    exports de.renew.plugin.di;
    exports de.renew.logging;
    exports de.renew.plugin.locate to de.renew.suite, de.renew.suite.creator, de.renew.javagora;
    exports de.renew.plugin.propertymanagement;

    // Java Dependencies
    requires java.xml;
    requires java.desktop;
    requires java.sql;
    requires java.instrument; // TODO: Remove me
    requires jdk.unsupported; // TODO: Remove me

    // Third-Party Dependencies
    requires ch.qos.reload4j;
    requires commons.cli;
}
