package de.renew.logging;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;


public class PatternLayoutTest {

    @Test
    public void testLeftPadWithShorterInput() {
        //given
        String exampleString = "tooshort";
        //when
        String actualString = PatternLayout.leftPad(exampleString, 10);
        //then
        assertEquals(10, actualString.length());
        assertEquals(exampleString + " " + " ", actualString);
    }

    @Test
    public void testLeftPadWithExactInput() {
        //given
        String exampleString = "exact";
        //when
        String actualString = PatternLayout.leftPad(exampleString, 5);
        //then
        assertEquals(5, actualString.length());
        assertEquals(exampleString, actualString);
    }

    @Test
    public void testLeftPadWithLongerInput() {
        //given
        String exampleString = "toolong";
        //when
        String actualString = PatternLayout.leftPad(exampleString, 5);
        //then
        assertEquals(5, actualString.length());
        assertEquals("toolo", actualString);
    }

    @Disabled("It makes no sense to test for specific return values that depend on java updates.")
    @Test
    public void testFormat() {
        //given
        Logger testLogger = Logger.getLogger(PatternLayoutTest.class);
        String testLoggerName = testLogger.getName();
        Level testLevel = Level.INFO;
        String testMessage = "Test message";

        LoggingEvent testLoggingEvent =
            new LoggingEvent(testLoggerName, testLogger, testLevel, testMessage, null);
        PatternLayout testPatternLayout = new PatternLayout();

        //when
        String actualString = testPatternLayout.format(testLoggingEvent);
        //then
        assertTrue(
            actualString
                .contains("[\u001b[0;33m" + "NativeMethodAccessorImpl" + ":" + "?" + "\u001B[m]"));
        assertTrue(actualString.contains(CliColor.color("INFO ", CliColor.BOLD, CliColor.GREEN)));
    }
}
