package de.renew.logging.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import de.renew.engine.events.ExceptionEvent;

/**
 * Custom renderer to visually display an error in the Table.
 */
public class ErrorLevelTableRenderer extends DefaultTableCellRenderer {

    /**
     * Changes the background of the current cell to a different color
     * if the cell is displaying an Exception.
     */
    @Override
    public Component getTableCellRendererComponent(
        JTable table, Object cellObject, boolean isSelected, boolean hasFocus, int row, int column)
    {
        Color c = table.getBackground();

        if (cellObject instanceof ExceptionEvent) {
            if (isSelected) {
                c = Color.ORANGE;
            } else {
                c = Color.RED;
            }
        }

        this.setBackground(c);

        Component renderer = super.getTableCellRendererComponent(
            table, cellObject, isSelected, hasFocus, row, column);
        if (renderer instanceof JLabel) {
            ((JLabel) renderer).setToolTipText(
                "<HTML>" + cellObject.toString().replaceAll("\n", "<BR>") + "</HTML>");
        }

        return renderer;
    }
}