package de.renew.logging.gui;

import org.apache.log4j.Appender;
import org.apache.log4j.Logger;


/**
 * Wraps a {@link Logger} and an {@link Appender} as a TreeNode
 *
 * @author Sven Offermann
 */
public class TreeNodeAppenderWrapper {
    private Logger _logger;
    private Appender _appender;

    /**
     * Creates new TreeNodeAppenderWrapper
     * @param logger the logger that shall be wrapped
     * @param appender the appender that shall be wrapped
     */
    public TreeNodeAppenderWrapper(Logger logger, Appender appender) {
        this._logger = logger;
        this._appender = appender;
    }

    /**
     * Getter for the logger
     * @return the logger
     */
    public Logger getLogger() {
        return this._logger;
    }

    /**
     * Getter for the appender
     * @return the appender
     */
    public Appender getAppender() {
        return this._appender;
    }

    @Override
    public String toString() {
        return this._appender.getClass().getName();
    }
}