package de.renew.lola2.commands;

import java.awt.Color;
import java.io.File;
import java.io.PrintStream;
import java.util.Vector;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.util.Command;
import de.renew.gui.CPNDrawing;
import de.renew.gui.PlaceFigure;
import de.renew.gui.VirtualPlaceFigure;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.analysis.DirectLolaResult;
import de.renew.lola2.analysis.PropertyAnalyzer;
import de.renew.lola2.gui.LolaGUIHelper;
import de.renew.plugin.command.CLCommand;

/**
 * Command to check if the selected place is bounded.
 * This command is used in the Lola2 plugin for checking properties of places in a CPN drawing.
 */
public class CheckSelectedPlaceCommand extends Command implements CLCommand {
    private String _lolaPath;
    private static org.apache.log4j.Logger _logger =
        org.apache.log4j.Logger.getLogger(CheckSelectedPlaceCommand.class);

    /**
     * Constructor for CheckSelectedPlaceCommand.
     * @param name the name of the command
     * @param path the path to the Lola file
     */
    public CheckSelectedPlaceCommand(String name, String path) {
        super(name);
        _lolaPath = path;
    }

    @Override
    public void execute() {
        DrawApplication app = DrawPlugin.getGui();
        CPNDrawing drawing = (CPNDrawing) app.drawing();
        // enable undo
        app.getUndoRedoManager().prepareUndoSnapshot(app.drawing());


        // get selected figures
        Vector<Figure> selection = app.view().selection();
        PropertyAnalyzer analyzer = new PropertyAnalyzer(_lolaPath);

        // Write lola File
        LolaFileCreator creator = new LolaFileCreator();
        File netFile = creator.writeTemporaryLolaFile(drawing);
        if (_logger.isDebugEnabled()) {
            _logger.debug(
                CheckAllCommand.class.getSimpleName() + ": temp file name: " + netFile.getPath());
        }

        for (Figure fig : selection) {
            DirectLolaResult result;
            if (fig instanceof PlaceFigure) {
                if (fig instanceof VirtualPlaceFigure) {
                    continue;
                }
                String placeName = creator.getNameForFigure(fig);
                result = analyzer.checkPlaceBoundedness(placeName, netFile);
                if (result != null) {
                    switch (result.getStatus()) {
                        case YES:
                            LolaGUIHelper.colorFigure(fig, Color.GREEN);
                            break;
                        case NO:
                            LolaGUIHelper.colorFigure(fig, Color.RED);
                            break;
                        default:
                            break;
                    }
                }
            }
        }

        app.getUndoRedoManager().commitUndoSnapshot(app.drawing());
    }

    @Override
    public void execute(String[] args, PrintStream response) {
        //TODO: implement the check from console
    }

    @Override
    public String getDescription() {
        return "Check if the selected place is bounded";
    }
}
