package de.renew.lola2.commands;

import java.awt.Color;
import java.io.File;
import java.io.PrintStream;
import java.util.Vector;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.util.Command;
import de.renew.gui.CPNDrawing;
import de.renew.gui.TransitionFigure;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.analysis.DirectLolaResult;
import de.renew.lola2.analysis.PropertyAnalyzer;
import de.renew.lola2.gui.LolaGUIHelper;
import de.renew.plugin.command.CLCommand;


/**
 * This command checks the liveness of the selected transitions in the CPN drawing.
 * It colors the transitions green if they are live and red if they are dead.
 */
public class CheckSelectedTransitionCommand extends Command implements CLCommand {
    private String _lolaPath;
    private static org.apache.log4j.Logger _logger =
        org.apache.log4j.Logger.getLogger(CheckSelectedTransitionCommand.class);

    /**
     * Constructor for the CheckSelectedTransitionCommand.
     * @param name the name of the command
     * @param path the path to the Lola executable
     */
    public CheckSelectedTransitionCommand(String name, String path) {
        super(name);
        _lolaPath = path;
    }

    @Override
    public void execute() {
        DrawApplication app = DrawPlugin.getGui();
        CPNDrawing drawing = (CPNDrawing) app.drawing();
        // enable undo
        app.getUndoRedoManager().prepareUndoSnapshot(app.drawing());


        // get selected figures
        Vector<Figure> selection = app.view().selection();
        PropertyAnalyzer analyzer = new PropertyAnalyzer(_lolaPath);

        // Write lola File
        LolaFileCreator creator = new LolaFileCreator();
        File netFile = creator.writeTemporaryLolaFile(drawing);
        if (_logger.isDebugEnabled()) {
            _logger.debug(
                CheckAllCommand.class.getSimpleName() + ": temp file name: " + netFile.getPath());
        }

        for (Figure fig : selection) {
            if (fig instanceof TransitionFigure) {
                String transitionName = creator.getNameForFigure(fig);
                DirectLolaResult result = analyzer.checkTransitionLiveness(transitionName, netFile);
                if (result != null) {
                    switch (result.getStatus()) {
                        case YES:
                            LolaGUIHelper.colorFigure(fig, Color.GREEN);
                            break;
                        case NO:
                            LolaGUIHelper.colorFigure(fig, Color.RED);
                            break;
                        default:
                            break;
                    }
                }
            }
        }

        app.getUndoRedoManager().commitUndoSnapshot(app.drawing());
    }

    @Override
    public void execute(String[] args, PrintStream response) {
        //TODO: implement the check from console
    }

    @Override
    public String getDescription() {
        return "Check if the selected transition is dead";
    }
}
