package de.renew.lola2.io;

import java.io.File;
import java.io.FileOutputStream;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.exportFormats.ExportFormatAbstract;
import de.renew.gui.CPNDrawing;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.LolaFileFilter;


/**
 * This class implements the Lola export format.
 * It is used to export CPN drawings in PT formalism to Lola format.
 * The exported file can be used for further processing in Lola.
 */
public class LolaExportFormat extends ExportFormatAbstract {
    /**
     * Logger for LolaExportFormat.
     */
    public static final org.apache.log4j.Logger LOGGER =
        org.apache.log4j.Logger.getLogger(LolaExportFormat.class);

    /**
     * Constructor for LolaExportFormat.
     * It initializes the export format with the name "Lola" and the associated file filter.
     */
    public LolaExportFormat() {
        super("Lola", new LolaFileFilter());
    }

    /**
     * Only CPNDrawing in PT formalism can be exported to lola format.
     */
    @Override
    public boolean canExportDrawing(Drawing drawing) {
        boolean result = false;
        if (drawing instanceof CPNDrawing) { // Simulator should be in PTnet mode
            result = true;
        }
        return result;
    }

    /**
     * n PT-Net drawings can't be exported to one lola file
     */
    @Override
    public boolean canExportNto1() {
        return false;
    }

    /**
     *
     */
    @Override
    public File export(Drawing drawing, File path) throws Exception {
        LolaFileCreator creator = new LolaFileCreator();
        File result = null;
        if (drawing != null && path != null) {
            result = path;
            FileOutputStream stream = new FileOutputStream(result);
            // write net file with lola format
            creator.writeLolaFile(stream, (CPNDrawing) drawing);
            stream.flush();
            stream.close();

            // now create task files
            //            creator.createTasks((CPNDrawing) drawing, path);
        }
        if (result != null) {
            // TODO works only with GUI, let the export crash, hence commented out
            //            DrawPlugin.getCurrent()
            //                      .showStatus("[Lola Export] Successfully exported drawing to "
            //                                  + path);
            LOGGER.info("[Lola Export] Successfully exported drawing to " + path);
        } else {
            LOGGER.error("Failure in LolaExportFormat: result == null");
        }
        return result;
    }

    /**
     *
     */
    @Override
    public File export(Drawing[] drawings, File path) throws Exception {
        File result = null;
        assert (result != null) : "Failure in LolaExportFormat: result == null";
        return result;
    }
}
