package de.renew.minimap;

import java.util.Collection;
import javax.swing.JMenuItem;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.util.CommandMenuItem;
import de.renew.minimap.command.ShowMiniMapCommand;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.annotations.Inject;
import de.renew.plugin.di.DIPlugin;
import de.renew.windowmanagement.Workbench;


/**
 * This is a generated file. Generated by PluginDevelopment
 * plugin (version 0.4)
 * Representative for the MiniMap plug-in.
 *
 * @author PluginGenerator
 */
public class MiniMapPlugin extends DIPlugin {
    JMenuItem _cmi;
    Workbench _fworkbench;

    /**
     * Creates an instance of the <code>MiniMapPlugin</code> object.
     *
     * @param workbench the {@link de.renew.windowmanagement.Workbench} to be used
     *                  for managing interactions between this plugin and the GUI.
     */
    @Inject
    public MiniMapPlugin(Workbench workbench) {
        _fworkbench = workbench;
    }

    /**
     * Retrieve the current instance of the <code>MiniMapPlugin</code>
     * from the {@link PluginManager}.
     *
     * @return  an active <code>MiniMapPlugin</code> instance or
     *          <code>null</code> if there isn't any.
     */
    public static MiniMapPlugin getCurrent() {
        MiniMapPlugin result = null;
        Collection<IPlugin> plugins =
            PluginManager.getInstance().getPluginsProviding("de.renew.minimap");
        for (IPlugin plugin : plugins) {
            if (plugin instanceof MiniMapPlugin) {
                result = (MiniMapPlugin) plugin;
                break;
            }
        }
        return result;
    }

    /** Deinitialize plugin.
     * {@link de.renew.plugin.PluginAdapter#cleanup()}
     */
    @Override
    public boolean cleanup() {
        super.cleanup();
        DrawPlugin current = DrawPlugin.getCurrent();
        if (current != null) {
            current.getMenuManager().unregisterMenu(_cmi);
        }
        return true;
    }

    /** Initialize the plugin, register menus and commands.
     * {@link de.renew.plugin.PluginAdapter#init()}
     */
    @Override
    public void init() {
        super.init();
        _cmi = new CommandMenuItem(new ShowMiniMapCommand(_fworkbench));
        DrawPlugin.getCurrent().getMenuManager()
            .registerMenu(DrawPlugin.PLUGINS_MENU, _cmi, "Show MiniMap");
        PluginManager.getInstance().addCLCommand("MiniMap", new ShowMiniMapCommand(_fworkbench));

    }
}