package de.renew.call;

import de.renew.engine.common.StepIdentifier;
import de.renew.engine.searcher.EarlyExecutable;
import de.renew.unify.Impossible;


class BlockExecutable implements EarlyExecutable {
    SynchronisationRequest _synchronisation;

    BlockExecutable(SynchronisationRequest synchronisation) {
        this._synchronisation = synchronisation;
    }

    @Override
    public int phase() {
        return BLOCK;
    }

    @Override
    public long lockPriority() {
        return _synchronisation._lockOrder;
    }

    /**
     * Locks the <code>SynchronisationRequest</code> associated with this arc.
     * @see SynchronisationRequest#_lock
     **/
    @Override
    public void lock() {
        _synchronisation._lock.lock();
    }

    @Override
    public void verify(StepIdentifier stepIdentifier) throws Impossible {
        if (_synchronisation._completed) {
            throw new Impossible();
        }
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        _synchronisation._completed = true;
    }

    @Override
    public void rollback() {
        // Nothing to do.
    }

    /**
     * Unlocks the <code>SynchronisationRequest</code> associated with this arc.
     * @see SynchronisationRequest#_lock
     **/
    @Override
    public void unlock() {
        _synchronisation._lock.unlock();
    }
}