package de.renew.navigator;

import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

import de.renew.navigator.gui.FileTreeCellRenderer;
import de.renew.navigator.models.TreeElement;


/**
 * @author Konstantin Simon Maria Moellers
 * @version 2015-10-14
 */
public interface NavigatorGui {

    /**
     * Opens the Navigator window.
     */
    void openWindow();

    /**
     * Closes the Navigator window.
     */
    void closeWindow();

    /**
     * Adds an extension to the GUI.
     *
     * @param extension the extension to add
     */
    void addExtension(NavigatorExtension extension);

    /**
     * Removes an extension from the GUI.
     *
     * @param extension The extension to remove
     * @return true if the extension was successfully removed
     */
    boolean removeExtension(NavigatorExtension extension);

    /**
     * Returns all activated NavigatorExtension of the Navigator GUI.
     *
     * @return a list of active {@link NavigatorExtension} instances
     */
    List<NavigatorExtension> getExtensions();

    /**
     * Returns the FileTreeCellRenderer of the Navigator GUI.
     *
     * @return the {@link FileTreeCellRenderer} instance
     */
    FileTreeCellRenderer getTreeCellRenderer();

    /**
     * Returns the JTree structure of the Navigator GUI.
     *
     * @return the {@link JTree} representing the file hierarchy
     */
    JTree getTree();

    /**
     * Returns the root node of the tree structure in the Navigator GUI.
     *
     * @return the {@link DefaultMutableTreeNode} representing the root of the tree
     */
    DefaultMutableTreeNode getRootNode();

    /**
     * Collapses all nodes in the tree, hiding their children.
     */
    void collapseAll();

    /**
     * Expands all nodes in the tree, revealing their children.
     */
    void expand();

    /**
     * Removes all currently selected nodes from the tree.
     */
    void removeSelectedNodes();

    /**
     * Returns all selected tree elements.
     *
     * @return a list of selected {@link TreeElement} instances
     */
    List<TreeElement> getSelectedElements();
}