package de.renew.navigator.gui.actions;

import java.awt.event.ActionEvent;

import de.renew.navigator.FilesystemController;
import de.renew.navigator.NavigatorAction;
import de.renew.navigator.gui.NavigatorIcons;


/**
 * @author Konstantin Simon Maria Moellers
 * @version 2015-08-26
 */
public class OpenNetPathAction extends NavigatorAction {
    /**
     * A reference to the {@link FilesystemController} responsible for handling
     * filesystem-related operations such as loading network paths and managing
     * filesystem access.
     *
     * This controller is utilized to perform various file and directory operations
     * required by the action. It provides the underlying logic for interacting
     * with the filesystem in a structured and consistent manner.
     */
    private final FilesystemController _fileSystem;

    /**
     * Constructs an {@code OpenNetPathAction} instance that opens network paths
     * specified in simulator plugin properties.
     * The associated filesystem controller is used to manage filesystem-related operations.
     *
     * @param filesystem the {@link FilesystemController} responsible for handling
     *                   filesystem operations
     */
    public OpenNetPathAction(final FilesystemController filesystem) {
        super("Open NetPaths of simulator properties", NavigatorIcons.ICON_NETPATH, null);
        this._fileSystem = filesystem;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            _fileSystem.loadFromNetPaths();
        } catch (RuntimeException e) {
            error(e.getMessage());
        }
    }
}