package de.renew.navigator.gui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;

import de.renew.navigator.NavigatorAction;
import de.renew.navigator.gui.NavigatorIcons;
import de.renew.navigator.models.NavigatorFileTree;


/**
 * @author Konstantin Simon Maria Moellers
 * @version 2015-08-26
 */
public class RemoveAllAction extends NavigatorAction {
    /**
     * The {@link NavigatorFileTree} instance that this action interacts with.
     */
    private final NavigatorFileTree _model;

    /**
     * Constructor for the RemoveAllAction.
     * @param model the {@link NavigatorFileTree} instance that this action interacts with.
     */
    public RemoveAllAction(final NavigatorFileTree model) {
        super(
            "Remove All (Ctrl+Shift+Delete)", NavigatorIcons.ICON_REMOVE_ALL, KeyStroke
                .getKeyStroke(KeyEvent.VK_DELETE, InputEvent.CTRL_MASK | InputEvent.SHIFT_MASK));
        this._model = model;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        _model.clearTreeRoots();
        _model.notifyObservers();
    }
}