package de.renew.navigator.gui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;

import de.renew.navigator.NavigatorAction;
import de.renew.navigator.NavigatorGui;
import de.renew.navigator.gui.NavigatorIcons;
import de.renew.navigator.models.NavigatorFileTree;


/**
 * @author Konstantin Simon Maria Moellers
 * @version 2015-08-26
 */
public class RemoveOneAction extends NavigatorAction {
    /**
     * The {@link NavigatorGui} instance that this action interacts with.
     */
    private final NavigatorGui _gui;
    /**
     * The {@link NavigatorFileTree} instance that this action interacts with.
     */
    private final NavigatorFileTree _model;

    /**
     * Constructor for the RemoveOneAction.
     * @param gui the {@link NavigatorGui} instance that this action interacts with.
     * @param model the {@link NavigatorFileTree} instance that this action interacts with.
     */
    public RemoveOneAction(final NavigatorGui gui, final NavigatorFileTree model) {
        super(
            "Remove Node", NavigatorIcons.ICON_REMOVE_ONE,
            KeyStroke.getKeyStroke(KeyEvent.VK_DELETE, 0));
        this._gui = gui;
        this._model = model;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        _gui.removeSelectedNodes();
    }
}