package de.renew.navigator.gui;

import java.io.File;
import javax.swing.tree.DefaultTreeCellRenderer;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import de.renew.navigator.models.Directory;
import de.renew.navigator.models.DirectoryType;
import de.renew.navigator.models.Leaf;
import de.renew.navigator.models.TreeElement;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class DefaultFileTreeCellRendererTest {

    private DefaultFileTreeCellRenderer renderer;

    @BeforeEach
    void setUp() {
        renderer = new DefaultFileTreeCellRenderer();
    }


    @Test
    public void testRenderLeafWithOntologyNameAndSetsIcon() {
        //given
        Leaf leaf = mock(Leaf.class);
        File file = new File("MyOntologyFile.java");
        when(leaf.getFile()).thenReturn(file);
        DefaultTreeCellRenderer target = new DefaultTreeCellRenderer();

        //when
        renderer.render(target, leaf, false, false);

        //then
        assertNotNull(target.getIcon());
        assertEquals(file.getAbsolutePath(), target.getToolTipText());
    }

    @Test
    public void testRenderLeafWithDCNamAndSetsIcon() {
        //given
        Leaf leaf = mock(Leaf.class);
        File file = new File("MyDCName.java");
        when(leaf.getFile()).thenReturn(file);

        DefaultTreeCellRenderer target = new DefaultTreeCellRenderer();

        //when
        renderer.render(target, leaf, false, false);

        //then
        assertNotNull(target.getIcon());
    }

    @Test
    public void testRenderSetsToolTipText() {
        //given
        TreeElement element = mock(TreeElement.class);
        File file = new File("some/path");
        when(element.getFile()).thenReturn(file);
        DefaultTreeCellRenderer target = new DefaultTreeCellRenderer();

        //when
        renderer.render(target, element, false, false);

        //then
        assertNotNull(target.getToolTipText());

    }

    @Test
    public void testRenderDirectoryAndSetsPackageIcon() {
        //given
        Directory direct = mock(Directory.class);
        when(direct.getType()).thenReturn(DirectoryType.PACKAGE);
        when(direct.getFile()).thenReturn(new File("someDirect"));

        DefaultTreeCellRenderer target = new DefaultTreeCellRenderer();

        //when
        renderer.render(target, direct, false, false);
        //then
        assertNotNull(target.getIcon());

    }
}