package de.renew.navigator.gui;

import java.awt.Point;
import java.io.File;
import java.util.Arrays;
import java.util.List;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import de.renew.navigator.FilesystemController;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoInteractions;

class DragDropListenerTest {

    private FilesystemController filesystemController;
    private DragDropListener listener;

    @BeforeEach
    void setUp() {
        filesystemController = mock(FilesystemController.class);
        listener = new DragDropListener(filesystemController);
    }

    @Test
    void testHandleFilesDrawing() {
        File file1 = new File("dir1");
        File file2 = new File("dir2");
        File[] files = new File[] { file1, file2 };
        Point dropLocation = new Point(10, 20);

        listener.handleFilesDrawing(files, dropLocation);

        List<File> expected = Arrays.asList(files);
        verify(filesystemController).loadRootDirectories(expected);
    }

    @Test
    void testHandleFilesImage() {
        File imageFile = new File("image.png");
        File[] files = new File[] { imageFile };
        Point dropLocation = new Point(5, 5);

        listener.handleFilesImage(files, dropLocation);

        verifyNoInteractions(filesystemController);
    }
}