package de.renew.navigator.gui.actions;

import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.ImageIcon;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.junit.jupiter.MockitoExtension;

import CH.ifa.draw.util.Iconkit;
import de.renew.navigator.NavigatorGui;
import de.renew.navigator.gui.NavigatorIcons;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertInstanceOf;
import static org.junit.jupiter.api.Assertions.assertSame;
import static org.mockito.Mockito.anyInt;
import static org.mockito.Mockito.anyString;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.mockStatic;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@ExtendWith(MockitoExtension.class)
class CollapseAllActionTest {

    @Mock
    NavigatorGui gui;

    @Mock
    Iconkit iconkit;

    @Test
    void constructorSetsTooltipAndIcon() {
        Image original = mock(Image.class);
        Image scaled = mock(Image.class);

        try (MockedStatic<Iconkit> ks = mockStatic(Iconkit.class)) {
            ks.when(Iconkit::instance).thenReturn(iconkit);
            when(iconkit.loadImage(NavigatorIcons.ICON_COLLAPSE_ALL)).thenReturn(original);
            when(original.getScaledInstance(-1, 16, Image.SCALE_SMOOTH)).thenReturn(scaled);

            CollapseAllAction action = new CollapseAllAction(gui);

            assertEquals("Collapse All (Ctrl+Shift+C)", action.getValue("ShortDescription"));
            // icon
            Object iconObj = action.getValue(Action.SMALL_ICON);
            assertInstanceOf(ImageIcon.class, iconObj);
            ImageIcon icon = (ImageIcon) iconObj;
            assertSame(scaled, icon.getImage());
            // human-readable name
            assertEquals("Collapse All", action.getActionName());
        }
    }

    @Test
    void actionPerformedCallsCollapseAll() {
        Image original = mock(Image.class);
        Image scaled = mock(Image.class);

        try (MockedStatic<Iconkit> ks = mockStatic(Iconkit.class)) {
            ks.when(Iconkit::instance).thenReturn(iconkit);
            when(iconkit.loadImage(anyString())).thenReturn(original);
            when(original.getScaledInstance(anyInt(), anyInt(), anyInt())).thenReturn(scaled);

            CollapseAllAction action = new CollapseAllAction(gui);
            action.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, null));

            verify(gui).collapseAll();
        }
    }
}
