package de.renew.navigator.gui.actions;

import java.awt.event.ActionEvent;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import de.renew.navigator.models.NavigatorFileTree;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;

public class RemoveAllActionTest {
    private RemoveAllAction removeAllAction;
    private NavigatorFileTree navigator;

    @BeforeEach
    void setUp() {
        //given
        navigator = mock(NavigatorFileTree.class);
        removeAllAction = new RemoveAllAction(navigator);
    }

    @Test
    public void testRemoveAllAction() {
        //when
        removeAllAction.actionPerformed(mock(ActionEvent.class));

        //then
        verify(navigator).clearTreeRoots();
        verify(navigator).notifyObservers();
    }
}