package de.renew.navigator.gui.actions;

import java.awt.event.ActionEvent;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import de.renew.navigator.NavigatorGui;
import de.renew.navigator.models.NavigatorFileTree;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;

public class RemoveOneActionTest {
    private RemoveOneAction removeOneAction;
    private NavigatorGui gui;

    @BeforeEach
    void setUp() {
        gui = mock(NavigatorGui.class);
        NavigatorFileTree fileTree = mock(NavigatorFileTree.class);
        removeOneAction = new RemoveOneAction(gui, fileTree);
    }

    @Test
    public void removeOneActionTest() {
        //given
        ActionEvent actionEvent = mock(ActionEvent.class);

        //when
        removeOneAction.actionPerformed(actionEvent);

        //then
        verify(gui).removeSelectedNodes();
    }
}