package de.renew.navigator.gui.filters;

import java.awt.event.ActionEvent;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;

import de.renew.navigator.models.NavigatorFileTree;
import de.renew.navigator.models.SearchFilter;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

class RNWSearchFilterTest {

    private NavigatorFileTree fileTree;
    private RNWSearchFilter filterAction;

    @BeforeEach
    void setUp() {
        fileTree = mock(NavigatorFileTree.class);
        filterAction = new RNWSearchFilter(fileTree);
    }

    @Test
    void actionPerformed_activatesFilter_whenNotAlreadyActive() {
        //given
        when(fileTree.getFileFilterByName("net")).thenReturn(null);

        //when
        filterAction.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, null));

        //then
        ArgumentCaptor<SearchFilter> captor = ArgumentCaptor.forClass(SearchFilter.class);
        verify(fileTree).activateFileFilter(captor.capture());
        SearchFilter sf = captor.getValue();

        assertEquals("net", sf.getName());
        assertEquals(SearchFilter.Type.ENDS_WITH, sf.getType());
        assertTrue(sf.isCaseSensitive());

        assertEquals(Boolean.TRUE, filterAction.getValue("active"));

        verify(fileTree).notifyObservers();
    }

    @Test
    void actionPerformed_deactivatesFilter_whenAlreadyActive() {
        //given
        SearchFilter existing = new SearchFilter(
            "net", SearchFilter.Type.ENDS_WITH, true, ".rnw", ".aip", ".draw", ".arm");
        when(fileTree.getFileFilterByName("net")).thenReturn(existing);

        //when
        filterAction.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, null));

        //then
        verify(fileTree).deactivateFileFilter("net");

        //and
        assertEquals(Boolean.FALSE, filterAction.getValue("active"));

        //and
        verify(fileTree).notifyObservers();
    }
}
