package de.renew.navigator.vc;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Set;

import org.apache.log4j.Logger;

import de.renew.navigator.NavigatorAction;
import de.renew.navigator.NavigatorGui;
import de.renew.navigator.models.TreeElement;


/**
 * Performs a Git diff on the current selected file.
 *
 * @author cabac, 1kmoelle
 */
final class VCColorAction extends NavigatorAction {
    /**
     * Log4j logger instance.
     */
    public static final Logger LOGGER = Logger.getLogger(VCColorAction.class);
    public static final String ICON = "NavigatorVC/src/main/resources/images/diff.gif";
    private final Set<Repository> _repositories;
    private final VersionControlAggregator _holder;
    private final NavigatorGui _gui;


    VCColorAction(
        Set<Repository> repositories, VersionControlAggregator aggregator, NavigatorGui gui)
    {
        super("Color changed files.", ICON, null);
        this._repositories = repositories;
        this._holder = aggregator;
        this._gui = gui;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final List<TreeElement> selectedElements = _gui.getSelectedElements();
        if (selectedElements.isEmpty()) {
            return;
        }

        final TreeElement treeElement = selectedElements.get(0);
        final Repository newRepository = _holder.findRepository(treeElement.getFile());
        if (newRepository != null) {
            _repositories.add(newRepository);

            _gui.getTree().repaint();
        }
    }
}
