<!-- Adapted from: https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/ -->

# Netcomponents

## User Guide

_Netcomponents_ provides functionality for adding netcomponent plugins.

### Features

- Add new palettes to the Gui
- Manage, group and remove added palettes
- Provides an overview over the available added palettes

### Example Usage

1. Open the new set of tools via Tools -> Netcomponents -> select from directory.
2. Select and open the folder which contains the new set of tools.
3. The new tools have now been added to the toolbar.

### Provided Commands

<!-- Use the classes implementing CLCommand. The 'help' output of the command can be a useful description -->

_Netcomponents_ does not provide CLCommands.

### Installation

Install _Netcomponents_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew.

### Dependencies

This plugin depends on the following plugins and external libraries:

<!-- must match the `module-info.java` -->

- `Gui`: Required for adding new tools to the Gui
- `log4j`: Logging framework

### Configuration

During the initialization of Netcomponents, the following properties are read from the `renew.properties` file in the Renew root directory.

**NAME**|**TYPE**|**DESCRIPTION**|**DEFAULT**
:-----|:-----:|:-----|:-----
`user.toolsdir` | `String` | Set to the path where the default tools are located. | tools
`de.renew.nc.init` | `boolean` | (Obsolete) Specifies whether the default palette is loaded on startup. | false

## Developer Guide

### Core Classes

- `ComponentsToolPlugin`: Implements the `IPlugin` interface to manage the startup and shutdown.
- `ComponentsTool`: Extends the usual functionality of the CPNApplication by adding a new palette to the gui.
- `InsertionTool`: Used for inserting a vector of figures into a drawing.

### How to Extend

_Netcomponents_ exposes one Interface, `ComponentsPluginExtender`. You can implement this interface to add additional tools to the Gui.

### Additional Information

<!-- Common issues, explanations for inconsistencies, etc. -->

Hint:
If you want to show the AIP palette on startup try

`de.renew.diagram.init=true`

in your ~/.renew.properties

<!-- Contribution Info -->

<!-- License -->
