package de.renew.netcomponents;

import java.util.Iterator;
import java.util.Vector;

import CH.ifa.draw.framework.FigureEnumeration;


/**
 * tools.Util.java
 *
 *
 * @author Lawrence Cabac
 * @version 0.1,  June 2002
 *
 */
public class Util {
    /**
     * Wraps the function "iterator2array" that converts an iterator of objects to an array of objects
     *
     * @param it - The iterator that we convert to an array
     *
     * @return the converted iterator as an array
     */
    public static Object[] it2a(Iterator<Object> it) {
        return iterator2array(it);
    }

    /**
     * Converts an iterator of objects to an array of objects
     *
     * @param it - The iterator that we convert to an array
     *
     * @return the converted iterator as an array
     */
    public static Object[] iterator2array(Iterator<Object> it) {
        Vector<Object> v = new Vector<Object>();

        while (it.hasNext()) {
            v.add(it.next());
        }

        return v.toArray();
    }

    /**
     * Wraps the function "figureEnumeration2array" that converts a FigureEnumeration Object to an array
     *
     * @param en - The FigureEnumeration object that we convert to an array
     *
     * @return the converted FigureEnumeration object as an array
     */
    public static Object[] f2a(FigureEnumeration en) {
        return figureEnumeration2array(en);
    }

    /**
     * Converts a FigureEnumeration Object to an array
     *
     * @param en - The FigureEnumeration object that we convert to an array
     *
     * @return the converted FigureEnumeration object as an array
     */
    public static Object[] figureEnumeration2array(FigureEnumeration en) {
        Vector<Object> v = new Vector<Object>();

        while (en.hasMoreElements()) {
            v.add(en.nextElement());
        }

        return v.toArray();
    }
} //class
