<!-- Adapted from: https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/ -->

# Renew Ant

## User Guide

_RenewAnt_ contains some additional or enhanced task implementations for the Apache Ant tool.
These tasks are needed for the Ant build process when compiling Renew. 
They are *not* needed to run or compile Renew itself.

### Features

- enables the Ant build process for Renew

### Example Usage

Was used to build renew with `ant clean dist`,before gradle was introduced

### Provided Commands

<!-- Use the classes implementing CLCommand. The 'help' output of the command can be a useful description -->

 _RenewAnt_ does not provide any Commands
### Installation

Install _RenewAnt_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew.


### Dependencies

This plugin depends on the following plugins and external libraries:

<!-- must match the `module-info.java` -->

- `ant`: To build Renew
- `log4j`: Logging framework
- `jfiglet`: Is used to create ascii art banners
- `antlr4`: For antlr4 tools

### Configuration

During the initialization of _RenewAnt_, no properties are read from the `renew.properties` file in the Renew root directory.

## Developer Guide

### Core Classes

- `AntTaskLogAppender`: These appender forwards a log message delivered by the log4j framework to the log method of a ant given task.
- `AbstractEnhancedJavaCCTask`:  Enhances the JavaCC task delivered with Ant to work on a file set.
- `LaTeX`: A class that runs LaTeX and BIBTeX.

### How to Extend

_RenewAnt_ is not meant to be extended.

### Additional Information

<!-- Common issues, explanations for inconsistencies, etc. -->

- _RenewAnt_ does not have a usual main class that implements the `IPlugin` Interface, like most plugins do
- _RenewAnt_ is only needed for building Renew and not for running it

<!-- Contribution Info -->

<!-- License -->
