package de.renew.ant;

import java.io.File;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.javacc.JJTree;

/**
 * Extends the JavaCCTask to work as JJTree task.
 *
 * @author Michael Haustermann
 */

public class EnhancedJJTreeTask extends AbstractEnhancedJavaCCTask {
    /**
     * Constructor,just calls the constructor of the superclass with the argument "jjtree".
     */
    public EnhancedJJTreeTask() {
        super("jjtree");
    }

    @Override
    protected void executeJavaCC(File javaccFile, File directory) throws BuildException {
        JJTree task = (JJTree) getProject().createTask(_singleTaskName);
        task.setJavacchome(_javacchome);
        task.setTarget(javaccFile);
        task.setOutputdirectory(directory);
        task.init();
        task.execute();
    }
}