package de.renew.database;

import de.renew.net.NetInstance;


/**
 * This class serves as an instance creator for a net with the possibilities of accessing
 * instance details such as the name in the form of a string and the id of the net instance.
 */
public class NetAction {
    private NetInstance instance;

    NetAction(NetInstance instance) {
        this.instance = instance;
    }

    /**
     * This method returns the current instance of the NetInstance.
     * @return the instance of the NetInstance
     */
    public NetInstance getNetInstance() {
        return instance;
    }

    /**
     * This method returns the name of the current instance of the NetInstance as a string.
     * @return the instance name in the form of a string
     */
    public String getName() {
        return instance.getNet().getName();
    }

    /**
     * This method returns the NetID of the current instance as a string.
     * @return the NetID of the current instance in the form of a string
     */
    public String getNetID() {
        return instance.getID();
    }
}