package de.renew.database;

import java.util.Hashtable;

import de.renew.net.NetInstance;


/**
 * This is a type safe wrapper around a hashtable.
 */
public class NetInstanceMap {
    /**
     * This is the default constructor for the NetInstanceMap class.
     */
    public NetInstanceMap() {}

    private Hashtable<String, NetInstance> table = new Hashtable<String, NetInstance>();

    /**
     * Associates the specified NetInstance with the given netID.
     * @param netID the ID of the NetInstance
     * @param instance the NetInstance to store
     */
    public void put(String netID, NetInstance instance) {
        table.put(netID, instance);
    }

    /**
     * Retrieves the NetInstance associated with the given netID.
     * @param netID the ID of the NetInstance to retrieve
     * @return the NetInstance associated with the netID, or null if none exists
     */
    public NetInstance get(String netID) {
        return table.get(netID);
    }
}