package de.renew.database;

import de.renew.net.NetElementID;
import de.renew.net.SimulatablePlaceInstance;


/**
 * This class represents an action involving a token in a simulatable place.
 */
public class TokenAction {
    private SimulatablePlaceInstance placeInstance;
    private Object token;
    private String tokenID;
    private double time;

    TokenAction(SimulatablePlaceInstance placeInstance, Object token, double time) {
        this.placeInstance = placeInstance;
        this.token = token;
        this.time = time;


        // Precalculate token ID. It will be needed anyway.
        this.tokenID = placeInstance.getTokenID(token);
    }

    /**
     * This method returns the placeInstance of the current instance.
     * @return the placeInstance
     */
    public SimulatablePlaceInstance getPlaceInstance() {
        return placeInstance;
    }

    /**
     * Returns the moved token.
     *
     * @see java.lang.Object
     * @see de.renew.util.Value
     *
     * @return the token, possibly wrapped in a <code>Value</code> object.
     */
    public Object getToken() {
        return token;
    }

    /**
     * This method returns the TokenID of the current instance as a string.
     * @return the tokenID as a string
     */
    public String getTokenID() {
        return tokenID;
    }

    /**
     * This method returns the NetID of the NetInstance place.
     * @return the id of the netInstance
     */
    public String getNetID() {
        return placeInstance.getNetInstance().getID();
    }

    /**
     * This method returns the PlaceID of the current place instance.
     * @return the id of the placeInstance
     */
    public NetElementID getPlaceID() {
        return placeInstance.getPlace().getID();
    }

    /**
     * This method returns the place's name of the current instance.
     * @return the name of the place of the place represented by the placeInstance
     */
    public String getPlaceName() {
        return placeInstance.getPlace().toString();
    }

    /**
     * Returns the time stamp of the moved token.
     *
     * @return a <code>double</code> valued time stamp
     */
    public double getTime() {
        return time;
    }
}