package de.renew.engine.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import de.renew.engine.searcher.AbstractOccurrence;
import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.Executable;
import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.OccurrenceDescription;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.VariableMapperCopier;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.TransitionInstance;
import de.renew.unify.Impossible;


/**
 * The base class for occurrences that derive their semantics from
 * a number of other occurrences.
 */
public class CompositeOccurrence extends AbstractOccurrence {
    private final List<Occurrence> occurrences = new ArrayList<>();

    public CompositeOccurrence(TransitionInstance tInstance) {
        super(tInstance);
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
    }

    public void addOccurrence(Occurrence occurrence) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        occurrences.add(occurrence);
    }

    public void addOccurrences(Collection<Occurrence> newOccurrences) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        occurrences.addAll(newOccurrences);
    }

    @Override
    public Collection<Binder> makeBinders(Searcher searcher) throws Impossible {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        List<Binder> binders = new ArrayList<>();
        for (Occurrence occurrence : occurrences) {
            binders.addAll(occurrence.makeBinders(searcher));
        }
        return binders;
    }

    @Override
    public Collection<Executable> makeExecutables(VariableMapperCopier variableMapperCopier) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        Collection<Executable> executables = new ArrayList<>();
        for (Occurrence occurrence : occurrences) {
            executables.addAll(occurrence.makeExecutables(variableMapperCopier));
        }
        return executables;
    }

    @Override
    public OccurrenceDescription makeOccurrenceDescription(
        VariableMapperCopier variableMapperCopier)
    {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        return null;
    }
}