package de.renew.engine.common;

import java.util.Collection;

import de.renew.engine.searcher.TriggerableCollection;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.unify.Variable;


public class EnumeratorBinder extends AssignBinder {
    private final EnumeratorOccurrence enumerator;

    EnumeratorBinder(EnumeratorOccurrence enumerator, boolean checkBound, Variable variable) {
        super(variable, checkBound);
        this.enumerator = enumerator;
    }

    @Override
    public final void lock() {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
    }

    @Override
    public final void unlock() {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
    }

    @Override
    public Collection<?> getCandidates(Object pattern) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        return enumerator.getCandidates(pattern);
    }

    @Override
    public TriggerableCollection getTriggerables() {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        return null;
    }
}