package de.renew.engine.searcher;


/**
 * A collection of {@link TriggerableCollection} objects.
 * It is stored at a {@link Triggerable} to record all triggers
 * ({@link TriggerableCollection} objects) of this object.
 * It is used to unregister the {@link Triggerable} from all
 * contained triggers ({@link TriggerableCollection} objects)
 * in the {@link #clear()} method.
 * <p>
 * The primary implementation is {@link TriggerCollectionImpl}.
 * The Distribute plugin has an own implementation that functions as a proxy
 * for a {@link TriggerCollectionImpl} in another Java VM via RMI.
 * <p>
 * Also see the description of {@link TriggerableCollection}.
 */
public interface TriggerCollection {
    void include(TriggerableCollection trigger);

    void exclude(TriggerableCollection trigger);

    void clear();
}