package de.renew.engine.simulator;

import de.renew.engine.common.StepIdentifier;
import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Searcher;


public class ExecuteFinder implements Finder {
    private Binding _binding;

    public ExecuteFinder() {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
    }

    @Override
    public void found(Searcher searcher) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        if (_binding != null) {
            throw new RuntimeException("ExecuteFinder was reused.");
        }
        _binding = new Binding(searcher);
    }

    @Override
    public boolean isCompleted() {
        return _binding != null;
    }

    public boolean execute(final StepIdentifier stepIdentifier, final boolean asynchronous) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        boolean result = _binding.execute(stepIdentifier, asynchronous);
        _binding = null;
        return result;

    }
}