package de.renew.net.arc;

import java.util.Collection;
import java.util.Collections;
import java.util.Vector;

import de.renew.engine.searcher.AbstractOccurrence;
import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.Executable;
import de.renew.engine.searcher.OccurrenceDescription;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.VariableMapperCopier;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.unify.Impossible;
import de.renew.unify.Variable;

/**
 * A {@code ClearArcOccurrence} is the occurrence of a {@link ClearArc}.
 */
class ClearArcOccurrence extends AbstractOccurrence {
    /** The place instance connected to the arc in the net in which the {@code ClearArcOccurrence} occurs. */
    SimulatablePlaceInstance placeInstance;
    /** The {@code VariableMapper} used for evaluating the arc's inscription. */
    VariableMapper mapper;
    /** The variable for the binding of the clear arc's inscription. */
    Variable variable;
    /** The {@code ClearArc} this is an occurrence of. */
    ClearArc arc;

    /**
     * Constructs a new {@code ClearArcOccurrence} based on a clear arc, a {@code variableMapper} and the
     * {@code NetInstance} it occurs in.
     *
     * @param arc the arc that the {@code ClearArcOccurrence} is an occurrence of
     * @param mapper the {@code VariableMapper} used for evaluating the arc's inscription
     * @param netInstance the {@code NetInstance} the {@code ClearArcOccurrence} occurs in
     */
    public ClearArcOccurrence(ClearArc arc, VariableMapper mapper, NetInstance netInstance) {
        super(netInstance.getInstance(arc.transition));
        this.arc = arc;
        this.mapper = mapper;
        placeInstance = (SimulatablePlaceInstance) netInstance.getInstance(arc.place);
    }

    @Override
    public Collection<Binder> makeBinders(Searcher searcher) throws Impossible {
        variable = new Variable(
            arc.expression.startEvaluation(mapper, searcher.recorder, searcher.calcChecker),
            searcher.recorder);

        searcher.calcChecker
            .addCalculated(arc.expression.getType(), variable, null, searcher.recorder);
        return Collections.emptySet();
    }

    @Override
    public Collection<Executable> makeExecutables(VariableMapperCopier variableMapperCopier) {
        Variable copiedVariable = (Variable) variableMapperCopier.getCopier().copy(variable);
        Collection<Executable> coll = new Vector<Executable>();
        coll.add(new ClearArcExecutable(placeInstance, getTransition(), copiedVariable, arc));
        return coll;
    }

    @Override
    public OccurrenceDescription makeOccurrenceDescription(
        VariableMapperCopier variableMapperCopier)
    {
        return null;
    }
}