package de.renew.net.event;

/**
 * An EventListener for events related to Places
 * and their marking.
 */
public interface PlaceEventListener extends NetEventListener {

    /**
     * This event method is called whenever the marking of
     * the corresponding PlaceInstance changes dramatically
     * (i.e. by more than one token).
     *
     * @param pe the PlaceEvent that triggered the change
     */
    public void markingChanged(PlaceEvent pe);

    /**
     * This event occurs when a single token (contained in the
     * event object) is put into the corresponding PlaceInstance.
     *
     * @param te the TokenEvent that triggered the change
     */
    public void tokenAdded(TokenEvent te);

    /**
     * This event occurs when a single token (contained in the
     * event object) is removed from the corresponding PlaceInstance.
     *
     * @param te the TokenEvent that triggered the change
     */
    public void tokenRemoved(TokenEvent te);

    /**
     * This event occurs when a token (contained in the
     * event object) is tested within the corresponding PlaceInstance.
     *
     * @param te the TokenEvent that triggered the change
     */
    public void tokenTested(TokenEvent te);

    /** This event occurs when a token (contained in the
     *  event object) is untested within the corresponding PlaceInstance.
     *
     * @param te the TokenEvent that triggered the change
     */
    public void tokenUntested(TokenEvent te);
}