package de.renew.net.event;

import de.renew.net.TransitionInstance;

/**
 * A general class for Transition-related net events.
 */
public abstract class TransitionEvent extends NetEvent {

    /**
     * Initializes the Event for a given instance
     *
     * @param instance the transition instance
     */
    protected TransitionEvent(TransitionInstance instance) {
        super(instance);
    }

    /**
     * Returns the event source as a TransitionInstance.
     *
     * @return the event source as a TransitionInstance
     */
    public TransitionInstance getTransitionInstance() {
        return (TransitionInstance) source;
    }
}