package de.renew.unify;

import java.io.Serializable;

// The Identity class restricts the equality of objects
// to their identity. Thereby two distinct, but equal
// objects can be seperated, e.g. in a hashtable.
class IdentityWrapper implements Serializable {
    private final Object _o;

    IdentityWrapper(Object o) {
        _o = o;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(_o);
    }

    @Override
    public boolean equals(Object id) {
        if (id instanceof IdentityWrapper identityWrapper) {
            return _o == identityWrapper._o;
        }
        return false;
    }

    public Object getObject() {
        return _o;
    }
}