<!-- Adapted from: https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/ -->

# Splashscreen

## User Guide

The plugin Splashscreen provides a JPanel that displays the loading progress on startup.

### Features

- Show an image with the current Renew version and the plugin loading process on startup.

### Example Usage

The Splashscreen appears on startup automatically if the configuration property inside the `plugin.cfg` file has been set to true.

### Provided Commands

_Splashscreen_ does not provide any commands.


### Installation

Install _Splashscreen_ by putting the JAR file inside the `plugins` directory.

It will be automatically loaded at startup of Renew - see below for more configuration options.

### Dependencies

This plugin depends on the following plugins and external libraries:

<!-- must match the `module-info.java` -->

- `Loader`: (mandated)
- `log4j`: Logging framework

### Configuration

During the initialization of _Splashscreen_, the following properties are read from the `renew.properties` file in the Renew root directory.

**NAME**|**TYPE**|**DESCRIPTION**|**DEFAULT**
:-----|:-----:|:-----|:-----
`de.renew.splashscreen.enabled`|boolean|Show the Splashscreen on startup| true

## Developer Guide

### Core Classes

- `RenewSplashScreen`: Creates and shows the the splashscreen
- `ImagePanel`: Shows the image called _splashscreen.png_ from the resources folder.
- `ExtendedProgressBar`: Container for the progress bar and a ScrollPane that lists the successfully loaded plugins

### How to Extend

_Splashscreen_ is not meant to be extended.

### Additional Information

<!-- Common issues, explanations for inconsistencies, etc. -->

- The _splashscreen.png_ image gets generated during the release pipeline. It is a `.rnw` image that gets updated to the current version number of Renew and then converted to a PNG image.

<!-- Contribution Info -->

<!-- License -->
